unit Trexdm03;

{
$Log:   W:/users/prodigy/prodig~1/archive/trex/trexdm03.pav  $
 * 
 *    Rev 1.0   07 Apr 1996 18:30:52   PaulK
 * Work in progress on demos
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, T_Rex, ExtCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Bevel1: TBevel;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    re: TRegExp;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);

var
  s: string;

begin
{This procedure creates and destroys the finite state
 recognizer for the regular expression each time the button
 is pressed. This is necessary here because the regular expression
 could be different each time. But in many programs, the regular
 expression is known at design time, or can be determined once
 at runtime. In these cases it is most inefficient to repeatedly
 compile and throw away the finite state recognizer, and the
 calls to TRegExp.Create and TRegExp.Free can be moved to points
 in the program where they are only executed once.}

re := TRegExp.Create(Edit1.Text);
s := Edit2.Text;
re.Subst(s,Edit3.Text,maxint);
Edit4.Text := s;
re.Free;
end;

end.
